USE VoxcoSystem
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Vx_sp_GetAgentSessionsForContext]') AND type in (N'P', N'PC'))
    DROP PROCEDURE [dbo].[Vx_sp_GetAgentSessionsForContext]
GO
CREATE PROCEDURE [dbo].[Vx_sp_GetAgentSessionsForContext]
    @contextId int,
    @userTimeZone int,
	@offset int,
	@limit int,
	@sort nvarchar(MAX),
	@filterAndSearch nvarchar(MAX),
    @SearchText nvarchar(MAX)

AS
BEGIN
	DECLARE @stmt nvarchar(MAX);

	IF @offset IS NULL
	BEGIN
		SET @offset = 0;
	END

	IF @sort IS NULL OR LEN(@sort) <= 0
	BEGIN
		SET @sort = N'[AgentSession].[sessionId] ASC';
	END

	IF @filterAndSearch IS NOT NULL AND LEN(@filterAndSearch) > 0
	BEGIN
		SET @filterAndSearch = ' AND ' + @filterAndSearch;
	END
	ELSE
	BEGIN
		SET @filterAndSearch = '';
	END

	SET @stmt = 'SELECT
		[sessionId],
		[userId],
		[projectId],
		[dbo].[VX_fn_FromUTC]([loginDateTime], @userTimeZone) AS [loginDateTime],
		CASE WHEN [logoutDateTime] IS NULL
			THEN NULL
			ELSE [dbo].[VX_fn_FromUTC]([logoutDateTime], @userTimeZone)
			END AS [logoutDateTime],
		[serverId],
		[TelephonyServerId],
		[AgentPhoneNumber],
		[ExtensionType],
		[testMode]
	FROM (
		SELECT
			ROW_NUMBER() OVER (ORDER BY ' + @sort + ') AS [RowNum], 
			[AgentSession].[sessionId],
			[AgentSession].[userId],
			[AgentSession].[projectId], 
			[AgentSession].[loginDateTime],
			[AgentSession].[logoutDateTime],
			[AgentSession].[serverId],
			[AgentSession].[TelephonyServerId],
			[AgentSession].[AgentPhoneNumber],
			[AgentSession].[ExtensionType],
			[AgentSession].[testMode]
		FROM [AgentSession]
		INNER JOIN [tblObjects] ON [AgentSession].[projectId] = [tblObjects].[k_Id]
		WHERE [tblObjects].[Context_Id] = @contextId' + @filterAndSearch + '
	) innerQuery
	WHERE [RowNum] > @offset' + CASE WHEN @limit IS NULL THEN '' ELSE ' AND [RowNum] <= @offset + @limit' END + '
	ORDER BY [RowNum];';

	EXEC sp_executesql @stmt, N'@contextId int, @userTimeZone int, @offset int, @limit int, @SearchText nvarchar(MAX)', @contextId, @userTimeZone, @offset, @limit, @SearchText;
END
GO
